<?php if(!defined('PLX_ROOT')) exit; ?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $plxAdmin->aConf['default_lang'] ?>" lang="<?php echo $plxAdmin->aConf['default_lang'] ?>">
<head>
	<meta name="robots" content="noindex, nofollow" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title><?php echo plxUtils::strCheck($plxAdmin->aConf['title']) ?> <?php echo L_ADMIN ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo strtolower(PLX_CHARSET) ?>" />
	<link rel="stylesheet" type="text/css" href="<?php echo PLX_CORE ?>admin/theme/css/bootstrap.min.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="<?php echo PLX_CORE ?>admin/theme/css/mix.css" media="screen" />
	<script type="text/javascript" src="<?php echo PLX_CORE ?>lib/functions.js"></script>
	<script type="text/javascript" src="<?php echo PLX_CORE ?>lib/visual.js"></script>
	<?php eval($plxAdmin->plxPlugins->callHook('AdminTopEndHead')) ?>
</head>
<body>
<div class="container">	
	<div class="row" id="content">
		<div class="col-md-3" id="sidebar">
			<div class="navbar navbar-default"> 
				<div class="navbar-header">
					<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<h4 class="center">
						<a title="PluXml <?php echo $plxAdmin->aConf['version'] ?>" href="http://www.pluxml.org">PluXml<span class="glyphicon glyphicon-leaf"></span><?php echo $plxAdmin->aConf['version'] ?></a>
						<?php echo L_ADMIN ?><span title="" class="glyphicon glyphicon-pencil"></span>
					</h4>
					<h5 class="center">
						<span title="<?php echo L_LOGIN ?>" class="glyphicon glyphicon-user"></span><?php echo plxUtils::strCheck($plxAdmin->aUsers[$_SESSION['user']]['name']) ?>
						<span title="<?php echo L_MENU_PROFIL ?>" class="glyphicon glyphicon-check"></span><?php
						if($_SESSION['profil']==PROFIL_ADMIN) echo L_PROFIL_ADMIN;
						elseif($_SESSION['profil']==PROFIL_MANAGER) echo L_PROFIL_MANAGER;
						elseif($_SESSION['profil']==PROFIL_MODERATOR) echo L_PROFIL_MODERATOR;
						elseif($_SESSION['profil']==PROFIL_EDITOR) echo L_PROFIL_EDITOR;
						else echo L_PROFIL_WRITER;
						?>
						<a href="auth.php?d=1" title="<?php echo L_ADMIN_LOGOUT_TITLE ?>" id="logout"><span title="<?php echo L_ADMIN_LOGOUT ?>" class="glyphicon glyphicon-off"></span></a>

						<a href="<?php echo PLX_ROOT ?>" title="<?php echo L_BACK_TO_SITE_TITLE ?>"><span title="<?php echo L_BACK_TO_SITE;?>" class="glyphicon glyphicon-home"></span></a>
						<?php if(isset($plxAdmin->aConf['homestatic']) AND !empty($plxAdmin->aConf['homestatic'])) : ?>
						<a href="<?php echo $plxAdmin->urlRewrite('?blog'); ?>" title="<?php echo L_BACK_TO_BLOG_TITLE ?>"><span title="<?php echo L_BACK_TO_BLOG;?>" class="glyphicon glyphicon-play"></span></a>
						<?php endif; ?>
					</h5>
				</div><!-- navbar-header -->
				<div class="navbar-collapse collapse">
					<ul class="nav navbar-navnav-stacked"><!-- nav  nav-pills -->
						<?php
							$menus = array();
							$userId = ($_SESSION['profil'] < PROFIL_WRITER ? '[0-9]{3}' : $_SESSION['user']);
							$nbartsmod = $plxAdmin->nbArticles('all', $userId, '_');
							$arts_mod = $nbartsmod>0 ? '&nbsp;<a class="cpt" href="index.php?sel=mod&amp;page=1" title="'.L_ALL_AWAITING_MODERATION.'">'.$nbartsmod.'</a>':'';
							$menus[] = plxUtils::formatMenu(L_MENU_ARTICLES, 'index.php?page=1', L_MENU_ARTICLES_TITLE, false, false,$arts_mod);

							if(isset($_GET['a'])) # edition article
								$menus[] = plxUtils::formatMenu(L_MENU_NEW_ARTICLES_TITLE, 'article.php', L_MENU_NEW_ARTICLES, false, false, '', false);
							else # nouvel article
								$menus[] = plxUtils::formatMenu(L_MENU_NEW_ARTICLES_TITLE, 'article.php', L_MENU_NEW_ARTICLES);

							$menus[] = plxUtils::formatMenu(L_MENU_MEDIAS, 'medias.php', L_MENU_MEDIAS_TITLE);

							if($_SESSION['profil'] <= PROFIL_MANAGER)
								$menus[] = plxUtils::formatMenu(L_MENU_STATICS, 'statiques.php', L_MENU_STATICS_TITLE);

							if($_SESSION['profil'] <= PROFIL_MODERATOR) {
								$nbcoms = $plxAdmin->nbComments('offline');
								$coms_offline = $nbcoms>0 ? '&nbsp;<a class="cpt" href="comments.php?sel=offline&amp;page=1">'.$plxAdmin->nbComments('offline').'</a>':'';
								$menus[] = plxUtils::formatMenu(L_MENU_COMMENTS, 'comments.php?page=1', L_MENU_COMMENTS_TITLE, false, false, $coms_offline);
							}
							
							if($_SESSION['profil'] <= PROFIL_EDITOR)
								$menus[] = plxUtils::formatMenu(L_MENU_CATEGORIES,'categories.php', L_MENU_CATEGORIES_TITLE);

							if($_SESSION['profil'] == PROFIL_ADMIN) {
								$menus[] = plxUtils::formatMenu(L_MENU_CONFIG, 'parametres_base.php', L_MENU_CONFIG_TITLE, false, false, '', false);
								if (preg_match('/parametres/',basename($_SERVER['SCRIPT_NAME']))) {
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_BASE,'parametres_base.php', L_MENU_CONFIG_BASE_TITLE, 'sub');
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_VIEW,'parametres_affichage.php', L_MENU_CONFIG_VIEW_TITLE, 'sub');
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_USERS,'parametres_users.php', L_MENU_CONFIG_USERS_TITLE, 'sub');
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_ADVANCED,'parametres_avances.php', L_MENU_CONFIG_ADVANCED_TITLE, 'sub');
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_PLUGINS,'parametres_plugins.php', L_MENU_CONFIG_PLUGINS_TITLE, 'sub');
									$menus[] = plxUtils::formatMenu(L_MENU_CONFIG_INFOS,'parametres_infos.php', L_MENU_CONFIG_INFOS_TITLE, 'sub');
								}
							}
							
							$menus[] = plxUtils::formatMenu(L_MENU_PROFIL, 'profil.php', L_MENU_PROFIL_TITLE);

							# récuperation des menus admin pour les plugins
							foreach($plxAdmin->plxPlugins->aPlugins as $plugName => $plugInstance) {
								if($plugInstance AND is_file(PLX_PLUGINS.$plugName.'/admin.php')) {
									if($plxAdmin->checkProfil($plugInstance->getAdminProfil(),false)) {
										if($plugInstance->adminMenu) {
											$menu = plxUtils::formatMenu(plxUtils::strCheck($plugInstance->adminMenu['title']), 'plugin.php?p='.$plugName, plxUtils::strCheck($plugInstance->adminMenu['caption']));
											array_splice($menus, ($plugInstance->adminMenu['position']-1), 0, $menu);
											$menus[]=$menu;
										} else {
											$menus[] = plxUtils::formatMenu(plxUtils::strCheck($plugInstance->getInfo('title')), 'plugin.php?p='.$plugName, plxUtils::strCheck($plugInstance->getInfo('title')));
										}
									}
								}
							}

							# Hook Plugins
							eval($plxAdmin->plxPlugins->callHook('AdminTopMenus'));
							echo implode('', $menus);
						?>
					</ul>
				</div><!-- navbar-collapse collapse -->
			</div><!-- navbar navbar-default -->
		</div> <!--col-md-3 sidebar -->
		<div class="col-md-9">
			<h1 id="sitename"><?php echo plxUtils::strCheck($plxAdmin->aConf['title']) ?></h1>
			<?php
			if(is_file(PLX_ROOT.'install.php')) echo L_WARNING_INSTALLATION_FILE;
					plxMsg::Display();
			?>
			<?php eval($plxAdmin->plxPlugins->callHook('AdminTopBottom')) ?>
