<?php

/**
 * Edition des pages statiques
 *
 * @package PLX
 * @author	Stephane F et Florent MONTHEL
 **/

include(dirname(__FILE__).'/prepend.php');

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Hook Plugins
eval($plxAdmin->plxPlugins->callHook('AdminStaticsPrepend'));

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN, PROFIL_MANAGER);

# On édite les pages statiques
if(!empty($_POST)) {
	if(isset($_POST['homeStatic']))
		$plxAdmin->editConfiguration($plxAdmin->aConf, array('homestatic'=>$_POST['homeStatic'][0]));
	else
		$plxAdmin->editConfiguration($plxAdmin->aConf, array('homestatic'=>''));
	$plxAdmin->editStatiques($_POST);
	header('Location: statiques.php');
	exit;
}

# On inclut le header
include(dirname(__FILE__).'/top.php');
?>
<script type="text/javaScript">
function checkBox(cb) {
	cbs=document.getElementsByName('homeStatic[]');
	for (var i = 0; i < cbs.length; i++) {
		if(cbs[i].checked==true) {
			cbs[i].checked = ((i+1) == cb) ? true: false;
		}
	}
}
</script>
<h2><?php echo L_STATICS_PAGE_TITLE ?></h2>

<?php eval($plxAdmin->plxPlugins->callHook('AdminStaticsTop')) # Hook Plugins ?>

<form action="statiques.php" method="post" id="form_statics">
	<div class="container"><div class="row">
	<div class="col-md-12">
		<div class="row">
			<div class="col-md-12"><span><input type="checkbox" onclick="checkAll(this.form, 'idStatic[]')" /></span></div>
		</div><!-- row -->
	<?php
	# Initialisation de l'ordre
	$num = 0;
	# Si on a des pages statiques
	if($plxAdmin->aStats) {
		foreach($plxAdmin->aStats as $k=>$v) { # Pour chaque page statique
			$ordre = ++$num;
			echo '<div class="row line-'.($num%2).'">';
			echo '<div class="col-md-1"><input type="checkbox" name="idStatic[]" value="'.$k.'" /><input type="hidden" name="staticNum[]" value="'.$k.'" /></div>';
			echo '<div class="col-md-2"><span>'.L_PAGE.': </span>'.$k.'</div><div class="col-md-2"><span>'.L_STATICS_HOME_PAGE.': </span>';
			$selected = $plxAdmin->aConf['homestatic']==$k ? ' checked="checked"' : '';
			echo '<input title="'.L_STATICS_PAGE_HOME.'" type="checkbox" name="homeStatic[]" value="'.$k.'"'.$selected.' onclick="checkBox(\''.$num.'\')" />';
			echo '</div><div class="col-md-2"><span>'.L_STATICS_GROUP.': </span>';
			plxUtils::printInput($k.'_group', plxUtils::strCheck($v['group']), 'text', '13-100');
			echo '</div><div class="col-md-2"><span>'.L_STATICS_TITLE.': </span>';
			plxUtils::printInput($k.'_name', plxUtils::strCheck($v['name']), 'text', '13-255');
			echo '</div><div class="col-md-2"><span>'.L_STATICS_URL.': </span>';
			plxUtils::printInput($k.'_url', $v['url'], 'text', '12-255');
			echo '</div><div class="col-md-3"><span>'.L_STATICS_ACTIVE.': </span>';
			plxUtils::printSelect($k.'_active', array('1'=>L_YES,'0'=>L_NO), $v['active']);
			echo '</div><div class="col-md-2"><span>'.L_STATICS_ORDER.': </span>';
			plxUtils::printInput($k.'_ordre', $ordre, 'text', '2-3');
			echo '</div><div class="col-md-3"><span>'.L_STATICS_MENU.': </span>';
			plxUtils::printSelect($k.'_menu', array('oui'=>L_DISPLAY,'non'=>L_HIDE), $v['menu']);

			if(!plxUtils::checkSite($v['url'])) {
				echo '</div><div class="col-md-4 right"><span>'.L_STATICS_ACTION.': </span>';
				echo '<a href="statique.php?p='.$k.'" title="'.L_STATICS_SRC_TITLE.'">'.L_STATICS_SRC.'</a>';
				if($v['active']) {
					echo '<a href="'.PLX_ROOT.'?static'.intval($k).'/'.$v['url'].'" title="'.L_STATIC_VIEW_PAGE.' '.plxUtils::strCheck($v['name']).' '.L_STATIC_ON_SITE.'">'.L_VIEW.'</a>';
				}
				echo '</div></div><!-- row -->';
			}
			else
				echo '</div><div class="col-md-4"><a href="'.$v['url'].'" title="'.plxUtils::strCheck($v['name']).'">'.L_VIEW.'</a></div></div><!-- row -->';
		}
		# On récupère le dernier identifiant
		$a = array_keys($plxAdmin->aStats);
		rsort($a);
	} else {
		$a['0'] = 0;
	}
	$new_staticid = str_pad($a['0']+1, 3, "0", STR_PAD_LEFT);
	?>
		<div class="row new">
			<div class="col-md-1">&nbsp;</div>
			<div class="col-md-2"><?php echo L_STATICS_NEW_PAGE ?></div>
			<div class="col-md-2">
			<?php
				echo '<input type="hidden" name="staticNum[]" value="'.$new_staticid.'" />';
				plxUtils::printInput($new_staticid.'_group', '', 'hidden', '13-100');
				echo '</div><div class="col-md-2">';
								echo '</div><div class="col-md-2"><span>'.L_STATICS_TITLE.': </span>';
				plxUtils::printInput($new_staticid.'_name', '', 'text', '13-255');
				plxUtils::printInput($new_staticid.'_template', 'static.php', 'hidden');
				echo '</div><div class="col-md-2"><span>'.L_STATICS_URL.': </span>';
				plxUtils::printInput($new_staticid.'_url', '', 'text', '12-255');
				echo '</div><div class="col-md-3"><span>'.L_STATICS_ACTIVE.': </span>';
				plxUtils::printSelect($new_staticid.'_active', array('1'=>L_YES,'0'=>L_NO), '0');
				echo '</div><div class="col-md-3"><span>'.L_STATICS_ORDER.': </span>';
				plxUtils::printInput($new_staticid.'_ordre', ++$num, 'text', '2-3');
				echo '</div><div class="col-md-3"><span>'.L_STATICS_MENU.': </span>';
				plxUtils::printSelect($new_staticid.'_menu', array('oui'=>L_DISPLAY,'non'=>L_HIDE), '1');
			?>
			</div>
			<div class="col-md-2">&nbsp;</div>
		</div><!-- row -->
	</div><!-- col-md-9 -->
	</div><!-- row --></div><!-- container -->
	<p class="center">
		<?php echo plxToken::getTokenPostMethod() ?>
		<input class="button update" type="submit" name="update" value="<?php echo L_STATICS_UPDATE ?>" />
	</p>
	<p>
		<?php plxUtils::printSelect('selection', array( '' =>L_FOR_SELECTION, 'delete' =>L_DELETE), '') ?>
		<input class="button submit" type="submit" name="submit" value="<?php echo L_OK ?>" />
	</p>
</form>

<?php
# Hook Plugins
eval($plxAdmin->plxPlugins->callHook('AdminStaticsFoot'));
# On inclut le footer
include(dirname(__FILE__).'/foot.php');
?>
