<?php

/**
 * Edition des catégories
 *
 * @package PLX
 * @author	Stephane F et Florent MONTHEL
 **/

include(dirname(__FILE__).'/prepend.php');

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Hook Plugins
eval($plxAdmin->plxPlugins->callHook('AdminCategoriesPrepend'));

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN, PROFIL_MANAGER, PROFIL_MODERATOR, PROFIL_EDITOR);

# On édite les catégories
if(!empty($_POST)) {
	$plxAdmin->editCategories($_POST);
	header('Location: categories.php');
	exit;
}

# Tableau du tri
$aTri = array('desc'=>L_SORT_DESCENDING_DATE, 'asc'=>L_SORT_ASCENDING_DATE, 'alpha'=>L_SORT_ALPHABETICAL);

# On inclut le header
include(dirname(__FILE__).'/top.php');
?>

<h2><?php echo L_CAT_TITLE ?></h2>

<?php eval($plxAdmin->plxPlugins->callHook('AdminCategoriesTop')) # Hook Plugins ?>

<form action="categories.php" method="post" id="form_categories">
	<div class="container"><div class="row">
	<div class="col-md-12">
		<div class="row">
			<div class="col-md-12"><input type="checkbox" onclick="checkAll(this.form, 'idCategory[]')" /></div>
		</div>
	<?php
	# Initialisation de l'ordre
	$num = 0;
	# Si on a des catégories
	if($plxAdmin->aCats) {
		foreach($plxAdmin->aCats as $k=>$v) { # Pour chaque catégorie
			$ordre = ++$num;
			echo '<div class="row line-'.($num%2).'">';
			echo '<div class="col-md-1"><input type="checkbox" name="idCategory[]" value="'.$k.'" /><input type="hidden" name="catNum[]" value="'.$k.'" /></div>';
			echo '<div class="col-md-3"><span>'.L_CAT_LIST_ID.': </span>'.L_CATEGORY.' '.$k.'</div>
				<div class="col-md-5"><span>'.L_CAT_LIST_NAME.': </span>';
			plxUtils::printInput($k.'_name', plxUtils::strCheck($v['name']), 'text', '15-50');
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_URL.': </span>';
			plxUtils::printInput($k.'_url', $v['url'], 'text', '15-50');
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_ACTIVE.': </span>';
			plxUtils::printSelect($k.'_active', array('1'=>L_YES,'0'=>L_NO), $v['active']);
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_SORT.': </span>';
			plxUtils::printSelect($k.'_tri', $aTri, $v['tri']);
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_BYPAGE.': </span>';
			plxUtils::printInput($k.'_bypage', $v['bypage'], 'text', '4-3');
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_ORDER.': </span>';
			plxUtils::printInput($k.'_ordre', $ordre, 'text', '3-3');
			echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_MENU.': </span>';
			plxUtils::printSelect($k.'_menu', array('oui'=>L_DISPLAY,'non'=>L_HIDE), $v['menu']);
			echo '</div>';
			echo '<div class="col-md-3 right"><a href="categorie.php?p='.$k.'">'.L_OPTIONS.'</a></div>';
			echo '</div><!-- row -->';
		}
		# On récupère le dernier identifiant
		$a = array_keys($plxAdmin->aCats);
		rsort($a);
	} else {
		$a['0'] = 0;
	}
	$new_catid = str_pad($a['0']+1, 3, "0", STR_PAD_LEFT);
	?>
		<div class="row new">
			<div class="col-md-1">&nbsp;</div>
			<div class="col-md-3"><?php echo L_NEW_CATEGORY ?></div>
			<div class="col-md-5"><?php echo L_CAT_LIST_NAME ?>
			<?php
				echo '<input type="hidden" name="catNum[]" value="'.$new_catid.'" />';
				plxUtils::printInput($new_catid.'_template', 'categorie.php', 'hidden');
				plxUtils::printInput($new_catid.'_name', '', 'text', '15-50');
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_URL.': </span>';
				plxUtils::printInput($new_catid.'_url', '', 'text', '15-50');
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_ACTIVE.': </span>';
				plxUtils::printSelect($new_catid.'_active', array('1'=>L_YES,'0'=>L_NO), '1');
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_SORT.': </span>';
				plxUtils::printSelect($new_catid.'_tri', $aTri, $plxAdmin->aConf['tri']);
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_BYPAGE.': </span>';
				plxUtils::printInput($new_catid.'_bypage', $plxAdmin->aConf['bypage'], 'text', '4-3');
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_ORDER.': </span>';
				plxUtils::printInput($new_catid.'_ordre', ++$num, 'text', '3-3');
				echo '</div><div class="col-md-3"><span>'.L_CAT_LIST_MENU.': </span>';
				plxUtils::printSelect($new_catid.'_menu', array('oui'=>L_DISPLAY,'non'=>L_HIDE), '1');
				echo '</div><div class="col-md-3">&nbsp;';
			?>
			</div>
		</div><!-- row -->
	</div><!-- col-md-9 -->
	</div><!-- row --></div><!-- container -->
	<p class="center">
		<?php echo plxToken::getTokenPostMethod() ?>
		<input class="button update " type="submit" name="update" value="<?php echo L_CAT_APPLY_BUTTON ?>" />
	</p>
	<p>
		<?php plxUtils::printSelect('selection', array( '' => L_FOR_SELECTION, 'delete' => L_DELETE), '') ?>
		<input class="button submit" type="submit" name="submit" value="<?php echo L_OK ?>" />
	</p>
</form>

<?php
# Hook Plugins
eval($plxAdmin->plxPlugins->callHook('AdminCategoriesFoot'));
# On inclut le footer
include(dirname(__FILE__).'/foot.php');
?>
