/**
 *  Objet de gestion de l'intgration de WYMeditor pour diter les articles
 *  de PluXml.
 *
 *  XXX Pas tip top comme implmentation mais le plus rapide. A voir plus tard
 *      pour une gestion plus propre et moins gourmande des instances d'diteur.
 */
var WEP = {
    /**
     * identifiant du textarea content
     * @type String
     */
    ID_CONTENT : 'id_content',
    /**
     * identifiant du textarea chapo
     * @type String
     */
    ID_CHAPO : 'id_chapo',
    
    /**
     * Chemin relatif du dossier plugin
     * @type String
     */
    dir : null,
    /**
     *  Liste des plugins WYMeditor  utiliser
     *  Les fichiers des plugins doivent avoir t dclars.
     *  @type String[]
     *  @private
     */
    plugins : [],
    /**
     *  Instance courante de l'diteur lors de l'insertion d'une image ou d'un
     *  lien depuis le gestionnaire de media.
     *  @type Object
     *  @private
     */
    current : null,
    
    /**
     *  Mthode d'initialisation  appeler pour grer les zones de texte content et
     *  chapo par WymEditor
     *  @param {String} dir Chemin du dossier du plugin.
     *  @param {String[]} plugins Liste des plugins WYMeditor  activer
     *  @param {String} lang Langue de l'interface
     *  @param {String} theme WYMeditor  utiliser
     *  @param {String} activer wymeditor pour les pages statique (0/1)
     */
    init: function (dir, plugins, lang, skin, statics) {
        WEP.dir = dir;
        WEP.lang = lang;
        WEP.plugins = plugins;
        WEP.skin = skin;
        WEP.statics = statics;
        WEP.process();
    },
    /**
     * Instanciation des diteurs
     */
    process: function () {
        var cfg = {
            lang: WEP.lang,
            stylesheet: WEP.dir + 'skin.css',
            skin: WEP.skin,
            postInit: WEP.postInit
        }, content, chapo;
        // N'utiliser wymeditor que sur les articles
        if (document.getElementById('form_article')) {
            content = jQuery('#'+WEP.ID_CONTENT).wymeditor(cfg);
            chapo = jQuery('#'+WEP.ID_CHAPO).wymeditor(cfg);
            if (content.length || chapo.length) {
                // Mise  jour du bouton de submit : ajout de classe wymupdate
                jQuery('input[type="submit"]').addClass('wymupdate');
            }
        } 
       // utiliser wymeditor sur les statiques
       else if (document.getElementById('form_static') && (WEP.statics == '1')) {
            content = jQuery('#'+WEP.ID_CONTENT).wymeditor(cfg);
            if (content.length) {
                // Mise  jour du bouton de submit : ajout de classe wymupdate
                jQuery('input[type="submit"]').addClass('wymupdate');
            }
        }/* */
    },
    
    /**
     *  Callback de post initialisation :
     *  - Lancement des plugins
     *  - Ajout du bouton de gestion des media
     *  @param {Object} wym instance de l'diteur WYMeditor
     */
    postInit: function(wym) {
        for (var i = 0, n = WEP.plugins.length; i < n; i++) {
            if (wym[WEP.plugins[i]]) {
                wym[WEP.plugins[i]]();
            }
        }
        //jQuery(wym._box).find(wym._options.toolsSelector).hide(); //all tools
		// masquer le bouton image
		// XXX Voir si API wymeditor fournit qq chose
        jQuery(wym._box).find('.wym_tools_image').hide();
        WEP.addMediasButton(wym);

        //adjust the editor's height
        var height = wym._element[0].id == 'id_content' ? '456' : '345';
        jQuery(wym._box).find(wym._options.iframeSelector)
            .css('height', height + 'px');
    },
    /**
     *  Ajout du bouton medias
     *  @param {Object} wym instance de l'diteur WYMeditor
     */
    addMediasButton: function (wym) {
		//construct the button's html
		var html = "<li class='wym_tools_mediabutton'><a name='MediaButton' href='#'" + 
				" title='Medias' style='background-image: url(" + WEP.dir + 
				"wymeditor/skins/default/icons.png); background-position: 0 -121px;'>" + 
				"Medias</a></li>";
		// add the button to the tools box
		jQuery(wym._box)
			.find(wym._options.toolsSelector + wym._options.toolsListSelector)
			.append(html);

		// handle click event
		// FIXME Vraiment, mais vraiment pas bon !
		jQuery(wym._box).find('li.wym_tools_mediabutton a').click(function () {
			WEP.current = wym;
			WEP.openPopup(WEP.dir + 'medias.php?id=' + wym._element[0].id.substr(3), 'Medias', '720', '580');
			return(false);
		});
    },
    
    /**
     *  Ouvrir la popup avec le fichier de gestion des medias
     *  @param {String} url Url de la page
     *  @param {String} name Titre de la fentre
     *  @param {int} width Largeur de la fentre
     *  @param {int} height Hauteur de la fentre
     */
    openPopup : function (url, name, width, height) {
		var popup = window.open(unescape(url) , name, "directories=no, toolbar=no, " + 
                "menubar=no, location=no, resizable=yes, scrollbars=yes, width=" + 
                width + " , height=" + height);
		if (popup) {
			popup.focus();
		} else {
			alert('Ouverture de la fentre bloque!');
		}
		return;
	},
	
    /**
     *  Mthode d'insertion d'une ressource.
     *  TODO Enrichir cette mthode.
     *  @param {String} id Identifiant de la zone dite.
     *  @param {String} url Url de la ressource.
     *  @param {String} type Type de la ressource (image).
     */  
    insert: function (id, url, type) {
        var html = '',
            w = url.split('/'),
            name = w.pop();
        if (type === 'image') {
            html = '<img src="' + url + '" alt="' + name + '">';
        } else {
            html = '<a href="' + url + '">' +
                    (type === 'thumb' ? '<img src="' + url + '" alt="' + name + '">' : name) +
                    '</a>';
        }
        WEP.current.paste(html);
    }
};
