<?php
/**
 **/
class WymEditor extends plxPlugin {
    const PLUGIN_NAME = 'WymEditor';
	/**
	 * Constructeur de la classe ckeditor
	 *
	 * @param	default_lang	langue par défaut utilisée par PluXml
	 * @return	null
	 **/
	public function __construct($default_lang) {

        # appel du constructeur de la classe plxPlugin (obligatoire)
        parent::__construct($default_lang);

		# droits pour accèder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);

		# Déclarations des hooks
		$this->addHook('AdminTopEndHead', 'AdminTopEndHead');
		$this->addHook('AdminFootEndBody', 'AdminFootEndBody');

		$this->addHook('plxAdminEditArticle', 'plxAdminEditArticle');
		$this->addHook('AdminArticleTop', 'AdminArticleTop');
	}

	/**
	 *  Méthode qui convertit les liens absolus en liens relatifs pour les images et les documents
	 */
	public function plxAdminEditArticle() {
        echo "<?php \$content['chapo'] = str_replace(\$this->racine.\$this->aConf['images'], \$this->aConf['images'], \$content['chapo']); ?>";
		echo "<?php \$content['content'] = str_replace(\$this->racine.\$this->aConf['images'], \$this->aConf['images'], \$content['content']); ?>";
		echo "<?php \$content['chapo'] = str_replace(\$this->racine.\$this->aConf['documents'], \$this->aConf['documents'], \$content['chapo']); ?>";
		echo "<?php \$content['content'] = str_replace(\$this->racine.\$this->aConf['documents'], \$this->aConf['documents'], \$content['content']); ?>";
	}

	/**
	 *  Méthode qui convertit les liens relatifs en liens absolus pour les images et les documents
	 */
	public function AdminArticleTop() {
        echo "<?php \$chapo = str_replace(\$plxAdmin->aConf['images'], \$plxAdmin->racine.\$plxAdmin->aConf['images'], \$chapo); ?>";
		echo "<?php \$content = str_replace(\$plxAdmin->aConf['images'], \$plxAdmin->racine.\$plxAdmin->aConf['images'], \$content); ?>";
		echo "<?php \$chapo = str_replace(\$plxAdmin->aConf['documents'], \$plxAdmin->racine.\$plxAdmin->aConf['documents'], \$chapo); ?>";
		echo "<?php \$content = str_replace(\$plxAdmin->aConf['documents'], \$plxAdmin->racine.\$plxAdmin->aConf['documents'], \$content); ?>";
	}

	/**
     *  Insertion des dépendances js et css
	 */
	public function AdminTopEndHead() { 
		// dépendances jquery nouvelle génération
		echo '
		<script type="text/javascript">
		if (typeof jQuery == \'undefined\') {
			document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'\/jquery\/jquery.js"><\/script>\');
		}
		</script>
		';
		echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/jquery/jquery.ui.js"></script>';
        // wymeditor et ses plugins
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/jquery.wymeditor.pack.js"></script>';//jquery.wymeditor.pack.js
        echo'<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/hovertools/jquery.wymeditor.hovertools.js"></script>';
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/resizable/jquery.wymeditor.resizable.js"></script>';
        
        /* wymeditor/plugins/fullscreen/jquery.wymeditor.fullscreen.js 
         * wymeditor/plugins/embed/jquery.wymeditor.embed.js
         * wymeditor/plugins/tidy/jquery.wymeditor.tidy.js
         * wymeditor/plugins/tidy/tidy.php
         * */
	}

	/**
     *  Insertion du script de gestion de Wymeditor
	 */
	public function AdminFootEndBody() {
        // script de gestion dans PluXml
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/plugin.js"></script>';
        echo '<script type="text/javascript">WEP.init("'.PLX_PLUGINS.self::PLUGIN_NAME.'/", ["hovertools", "resizable"],"'.$_SESSION['lang'].'","'.$this->getParam('wymskin').'","'.$this->getParam('wymonstatic').'")</script>';
	}
}
?>
