<?php
/**
 * Edition des utilisateurs
 *
 * @package PLX
 * @author	Stephane F.
 **/

include(dirname(__FILE__).'/prepend.php');

# Control du token du formulaire
plxToken::validateFormToken($_POST);

# Control de l'accès à la page en fonction du profil de l'utilisateur connecté
$plxAdmin->checkProfil(PROFIL_ADMIN);

# Edition des utilisateurs
if (!empty($_POST)) {
	$plxAdmin->editUsers($_POST);
	header('Location: parametres_users.php');
	exit;
}

# Tableau des profils
$aProfils = array(
	PROFIL_ADMIN => L_PROFIL_ADMIN,
	PROFIL_MANAGER => L_PROFIL_MANAGER,
	PROFIL_MODERATOR => L_PROFIL_MODERATOR,
	PROFIL_EDITOR => L_PROFIL_EDITOR,
	PROFIL_WRITER => L_PROFIL_WRITER
);

# On inclut le header
include(dirname(__FILE__).'/top.php');
?>

<h2><?php echo L_CONFIG_USERS_TITLE; ?></h2>

<?php eval($plxAdmin->plxPlugins->callHook('AdminUsersTop')) # Hook Plugins ?>

<form action="parametres_users.php" method="post" id="form_users">
	<div class="container"><div class="row">
	<div class="col-md-9">
		<div class="row">
			<div class="col-md-12"><input type="checkbox" onclick="checkAll(this.form, 'idUser[]')" /></div>
		</div>
	<?php
	# Initialisation de l'ordre
	$num = 0;
	if($plxAdmin->aUsers) {
		foreach($plxAdmin->aUsers as $_userid => $_user)	{
			if (!$_user['delete']) {
				echo '<div class="row line-'.($num%2).'">';
				echo '<div class="col-md-1"><input type="checkbox" name="idUser[]" value="'.$_userid.'" /><input type="hidden" name="userNum[]" value="'.$_userid.'" /></div>';
				echo '<div class="col-md-3"><span>'.L_CONFIG_USERS_ID.': </span>Utilisateur '.$_userid.'</div>
					<div class="col-md-4"><span>'.L_PROFIL_USER.': </span>';
				plxUtils::printInput($_userid.'_name', plxUtils::strCheck($_user['name']), 'text', '20-255');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL_LOGIN.': </span>';
				plxUtils::printInput($_userid.'_login', plxUtils::strCheck($_user['login']), 'text', '11-255');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL_PASSWORD.': </span>';
				plxUtils::printInput($_userid.'_password', '', 'password', '11-255');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL.': </span>';
				if($_userid=='001') {
					plxUtils::printSelect($_userid.'_profil', $aProfils, $_user['profil'], true, 'readonly');
					echo '</div><div class="col-md-3"><span>'.L_CONFIG_USERS_ACTIVE.': </span>';
					plxUtils::printSelect($_userid.'_active', array('1'=>L_YES,'0'=>L_NO), $_user['active'], true, 'readonly');
				} else {
					plxUtils::printSelect($_userid.'_profil', $aProfils, $_user['profil']);
					echo '</div><div class="col-md-3"><span>'.L_CONFIG_USERS_ACTIVE.': </span>';
					plxUtils::printSelect($_userid.'_active', array('1'=>L_YES,'0'=>L_NO), $_user['active']);
				}
				echo '</div>';
				echo '<div class="col-md-1 right"><span>'.L_CONFIG_USERS_ACTION.': </span><a href="user.php?p='.$_userid.'">'.L_OPTIONS.'</a></div>';
				echo '</div><!-- row -->';
			}
		}
		# On récupère le dernier identifiant
		$a = array_keys($plxAdmin->aUsers);
		rsort($a);
	} else {
		$a['0'] = 0;
	}
	$new_userid = str_pad($a['0']+1, 3, "0", STR_PAD_LEFT);
	?>
		<div class="row new">
		<div class="col-md-1">&nbsp;</div>
			<div class="col-md-3"><span><?php echo L_CONFIG_USERS_NEW; ?></div>
			<div class="col-md-4"><span><?php echo L_PROFIL_USER; ?>: </span>
			<?php
				echo '<input type="hidden" name="userNum[]" value="'.$new_userid.'" />';
				plxUtils::printInput($new_userid.'_newuser', 'true', 'hidden');
				plxUtils::printInput($new_userid.'_name', '', 'text', '20-255');
				plxUtils::printInput($new_userid.'_infos', '', 'hidden');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL_LOGIN.': </span>';
				plxUtils::printInput($new_userid.'_login', '', 'text', '11-255');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL_PASSWORD.': </span>';
				plxUtils::printInput($new_userid.'_password', '', 'password', '11-255');
				echo '</div><div class="col-md-4"><span>'.L_PROFIL.': </span>';
				plxUtils::printSelect($new_userid.'_profil', $aProfils, PROFIL_WRITER);
				echo '</div><div class="col-md-3"><span>'.L_CONFIG_USERS_ACTIVE.': </span>';
				plxUtils::printSelect($new_userid.'_active', array('1'=>L_YES,'0'=>L_NO), '1');
				echo '</div>';
			?>
			<div class="col-md-1">&nbsp;</div>
		</div><!-- row -->
	</div><!-- col-md-9 -->
	</div><!-- row --></div><!-- container -->
	<p class="center">
		<?php echo plxToken::getTokenPostMethod() ?>
		<input class="button update" type="submit" name="update" value="<?php echo L_CONFIG_USERS_UPDATE ?>" />
	</p>
	<p>
		<?php plxUtils::printSelect('selection', array( '' => L_FOR_SELECTION, 'delete' => L_DELETE), '') ?>
		<input class="button submit" type="submit" name="submit" value="<?php echo L_OK ?>" />
	</p>
</form>

<?php
# Hook Plugins
eval($plxAdmin->plxPlugins->callHook('AdminUsersFoot'));
# On inclut le footer
include(dirname(__FILE__).'/foot.php');
?>
