<?php
/**
 * Plugin plxResponsiveSlidesJs
 * @author	Stephane F
 * @fourcheur Thomas I
 **/

include(dirname(__FILE__).'/lib/class.plx.responslidesjs.php');

class plxResponsiveSlidesJs extends plxPlugin {

	public $responslidesjs = null; # objet responslidesjs

	public function __construct($default_lang) {

        # appel du constructeur de la classe plxPlugin (obligatoire)
        parent::__construct($default_lang);

		# droits pour accèder à la page config.php et admin.php du plugin
		$this->setConfigProfil(PROFIL_ADMIN);
		$this->setAdminProfil(PROFIL_ADMIN);

		$this->addHook('AdminMediasTop', 'AdminMediasTop');
		$this->addHook('AdminMediasPrepend', 'AdminMediasPrepend');

		$this->responslidesjs = new responslidesjs();
		$this->responslidesjs->getSlides();

        # déclaration des hooks
		if($this->responslidesjs->aSlides) {
			$this->addHook('ThemeEndHead', 'ThemeEndHead');
			$this->addHook('ThemeEndBody', 'ThemeEndBody');
			$this->addHook('ResponsiveSlidesJs', 'ResponsiveSlidesJs');
		}

    }

	public function AdminMediasTop() {

		echo '<?php
		$arr = array("ResponsiveSlidesJs" => array("responslidesjs_add" => "Ajouter au diaporama"));
		$selectionList = array_merge($selectionList, $arr);
		?>';

	}

	public function AdminMediasPrepend() {

		if(isset($_POST['selection']) AND ($_POST['selection'][0] == 'responslidesjs_add' OR $_POST['selection'][1] == 'responslidesjs_add') AND isset($_POST['idFile'])) {
			$this->responslidesjs->editSlides($_POST);
			header('Location: medias.php');
			exit;
		}

	}

	public function ResponsiveSlidesJs() {

		if($this->responslidesjs->aSlides) {
			echo "\n<div class=\"rslides_container\">\n<ul class=\"rslides\" id=\"responsiveslides\">\n";
			foreach($this->responslidesjs->aSlides as $slide) {
				if($slide['active']) {
					$onclick = $slide['onclick']!='' ? $slide['onclick'] : $slide['url'];
					echo '<li><a href="'.plxUtils::strCheck($onclick).'"><img src="'.plxUtils::strCheck($slide['url']).'" title="'.plxUtils::strCheck($slide['title']).'" /><p class="caption">'.strip_tags($slide['description'], '<strong><b><em><br>')."</p></a></li>\n";
				}
			}
			echo "</ul>\n</div>\n";
		}
	}

	public function ThemeEndHead() {
		echo "\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxResponsiveSlidesJs/responsiveslides/responsiveslides-styles.css" media="screen" />'."\n";
		echo "\t".'
		<style type="text/css">
		.rslides_container { max-width: '.$this->getParam('maxwidth').'px; max-height: '.$this->getParam('maxheight').'px; }
		</style>
		';
	}

	public function ThemeEndBody() {

		echo "\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxResponsiveSlidesJs/responsiveslides/responsiveslides.min.js"></script>'."\n";
		$keys = array('speed','pager','timeout','prevText','nextText','auto','namespace','nav','random','pause','pauseControls');
		$parms = $this->getParams();
		$array= array();
		foreach($parms as $key => $value) {
			if(in_array($key, $keys) AND ($value['value']!='' OR $value['value']==1)) {
				if(in_array($key, array('nav','random','pause')))
					$array[] = $key.':'.($value['value']==1?'true':'false');
				elseif($value['type']=='numeric')
					$array[] = $key.':'.$value['value'];
				else
					$array[] = $key.":'".$value['value']."'";
			}
		}
		$string = $array ? implode(',',$array) : '';
	?>

<script type="text/javascript">
if (typeof jQuery == 'undefined') {
	document.write('<script type="text\/javascript" src="<?php echo PLX_PLUGINS ?>plxResponsiveSlidesJs\/responsiveslides\/jquery.min.js"><\/script>');
}
$(document).ready(function() {
	$('#responsiveslides').responsiveSlides({<?php echo $string ?>});
});
</script>

	<?php
	}
}
?>
