<?php
/**
 * Plugin WymEditor for Pluxml
 *
 * @package	WymEditor
 * @version	1.1.2
 * @date	17.03.2017
 * @author	SudWebDesign.fr
 **/
class WymEditor extends plxPlugin {
    const PLUGIN_NAME = 'WymEditor';
 /**
  * Constructeur de la classe ckeditor
  *
  * @param default_lang langue par défaut utilisée par PluXml
  * @return null
  **/
 public function __construct($default_lang) {
  parent::__construct($default_lang);
  # Déclarations des hooks
  if(strstr($_SERVER['PHP_SELF'],'article.php') || strstr($_SERVER['QUERY_STRING'],'plxMyShop&prod')) {//édit art or prod slmnt
   $this->addHook('AdminTopEndHead', 'AdminTopEndHead');
   $this->addHook('AdminFootEndBody', 'AdminFootEndBody');
  }
  $this->addHook('plxAdminEditArticleXml', 'plxAdminEditArticleXml');
  $this->addHook('plxAdminEditArticle', 'plxAdminEditArticle');
  $this->addHook('AdminArticleTop', 'AdminArticleTop');
  $this->addHook('AdminMediasFoot', 'AdminMediasFoot');
 }

 /** 
  *  Méthode qui supprime les <br /> lorsque les textareas sont laissé tel quel a l'enregistrement et a chaque fin de paragraphe, liste, ...
  */
 public function plxAdminEditArticleXml() {
  echo "<?php \$xml = str_replace(array('[<br />]','<br /></'),array('[]','</'),\$xml); ?>";
 }

 /**
  *  Méthode qui convertit les liens absolus en liens relatifs pour les medias, images et les documents?
  */
 public function plxAdminEditArticle() {
  echo "<?php
 if(isset(\$this->aConf['medias'])){// plx.5.4+
   \$content['chapo'] = str_replace(\$this->racine.\$this->aConf['medias'], \$this->aConf['medias'], \$content['chapo']);
   \$content['content'] = str_replace(\$this->racine.\$this->aConf['medias'], \$this->aConf['medias'], \$content['content']);
 }else{
   \$content['chapo'] = str_replace(\$this->racine.\$this->aConf['images'], \$this->aConf['images'], \$content['chapo']);
   \$content['content'] = str_replace(\$this->racine.\$this->aConf['images'], \$this->aConf['images'], \$content['content']);
   \$content['chapo'] = str_replace(\$this->racine.\$this->aConf['documents'], \$this->aConf['documents'], \$content['chapo']);
   \$content['content'] = str_replace(\$this->racine.\$this->aConf['documents'], \$this->aConf['documents'], \$content['content']);
 }
?>";
  }

 /**
  *  Méthode qui convertit les liens relatifs en liens absolus pour les medias, images et les documents?
  */
 public function AdminArticleTop() {
  echo "<?php
 if(isset(\$plxAdmin->aConf['medias'])){// plx.5.4+
   \$chapo = str_replace(\$plxAdmin->aConf['medias'], \$plxAdmin->racine.\$plxAdmin->aConf['medias'], \$chapo);
   \$content = str_replace(\$plxAdmin->aConf['medias'], \$plxAdmin->racine.\$plxAdmin->aConf['medias'], \$content);
 }else{
   \$chapo = str_replace(\$plxAdmin->aConf['images'], \$plxAdmin->racine.\$plxAdmin->aConf['images'], \$chapo);
   \$content = str_replace(\$plxAdmin->aConf['images'], \$plxAdmin->racine.\$plxAdmin->aConf['images'], \$content);
   \$chapo = str_replace(\$plxAdmin->aConf['documents'], \$plxAdmin->racine.\$plxAdmin->aConf['documents'], \$chapo);
   \$content = str_replace(\$plxAdmin->aConf['documents'], \$plxAdmin->racine.\$plxAdmin->aConf['documents'], \$content);
 }
?>";
 }

 /**
  *  Insertion des dépendances js et css
  */
 public function AdminTopEndHead() {
  //mediaManager
  if(!file_exists(PLX_ROOT.'/core/lib/mediasManager.js'))
   echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/mediasManager.js"></script>'.PHP_EOL;//FROM PLX 5.5
  // dépendances jquery
  echo '
  <link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.self::PLUGIN_NAME.'/jquery/jquery.ui.resizable.css" />
  <link rel="stylesheet" href="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/skins/compact/skin.css">
  <link rel="stylesheet" href="'.PLX_PLUGINS.self::PLUGIN_NAME.'/skin.css">
  <script type="text/javascript">
  if (typeof jQuery == \'undefined\') {
   document.write(\'<script type="text\/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'\/jquery\/jquery-1.12.4.min.js"><\/script>\');
  }
  </script>
  ';

  //~ echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/jquery/jquery-ui-1.8.11.custom.min.js"></script>'.PHP_EOL;
  echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/jquery/jquery-ui-1.12.1.custom.min.js"></script>'.PHP_EOL;
        // wymeditor et ses plugins
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/jquery.wymeditor.js"></script>'.PHP_EOL;//jquery.wymeditor.pack.js
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/hovertools/jquery.wymeditor.hovertools.js"></script>'.PHP_EOL;
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/resizable/jquery.wymeditor.resizable.js"></script>'.PHP_EOL;
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/fullscreen/jquery.wymeditor.fullscreen.js"></script>'.PHP_EOL;
        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/table/jquery.wymeditor.table.js"></script>'.PHP_EOL;


        echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/embed/jquery.wymeditor.embed.js"></script>'.PHP_EOL;
        //echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/tidy/jquery.wymeditor.tidy.js"></script>'.PHP_EOL;
        //echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/list/jquery.wymeditor.list.js"></script>'.PHP_EOL;
        //echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/rdfa/jquery.wymeditor.rdfa.js"></script>'.PHP_EOL;
        //echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/wymeditor/plugins/structured_headings/jquery.wymeditor.structured_headings.js"></script>'.PHP_EOL;
 }

 /**
  *  changement de onclic target blank en lien retour de Wymeditor
  */
 public function AdminMediasFoot(){ ?>
<script type="text/javascript">
if (window.opener && window.opener.WEP){
 var tbody = document.getElementsByTagName('tbody');
 var ancres = tbody[0].getElementsByTagName('a');
 for (var i = 0; i < ancres.length; i++){
  if(ancres[i].getAttribute('onclick')){
   var str = ancres[i].getAttribute('onclick');
   var res = str.substr(0, 4);// this OR over[lay]
   if(res == 'this'){
    var type = 'document';
    if ((/\.(gif|jpg|jpeg|png)$/i).test(ancres[i].href))
     type = 'image';
    if (/\.(tb)\./i.test(ancres[i].href))
     type = 'thumb';
    if (/\.(mp3|ogg|wav)/i.test(ancres[i].href))
     type = 'audio';
    if (/\.(mp4|ogv|webm)/i.test(ancres[i].href))
     type = 'video';

    ancres[i].setAttribute('onclick','window.opener.WEP.insert(this.href,"'+ancres[i].title+'","'+type+'");window.close();return false;')
    ancres[i].style.color="red";
    ancres[i].title = "Ajouter "+ancres[i].title+" a l'article ("+type+").";
   }
  }
 }
}
</script>
<?php
 }

 /**
  *  Insertion du script de gestion de Wymeditor
  */
 public function AdminFootEndBody() {
  // script de gestion dans PluXml
  echo '<script type="text/javascript" src="'.PLX_PLUGINS.self::PLUGIN_NAME.'/plugin.js"></script>';
  echo '
<script type="text/javascript">
  WEP.init("'.PLX_PLUGINS.self::PLUGIN_NAME.'/", 
  ["table", "hovertools", "resizable", "fullscreen", "embed"],"fr","compact")
</script>';
  //mediaManager
  if(!file_exists(PLX_ROOT.'/core/lib/mediasManager.js'))//FROM PLX 5.5
   echo '
<script type="text/javascript">
 mediasManager.construct({
  windowName : "<?php echo L_MEDIAS_TITLE ?>",
  racine: "<?php echo plxUtils::getRacine() ?>",
  urlManager: "core/admin/medias.php"
 });
</script>';
 }
}
?>
