<?php
/**
 * Plugin plxResponsiveSlidesJs
 * @author Stephane F
 * @fourcheur Thomas I
 **/

include(dirname(__FILE__).'/lib/class.plx.responslidesjs.php');

class plxResponsiveSlidesJs extends plxPlugin {

 public $responslidesjs = null; # objet responslidesjs

 public function __construct($default_lang){
  # appel du constructeur de la classe plxPlugin (obligatoire)
  parent::__construct($default_lang);

  # Autorisation d'accès à l'administration du plugin#, PROFIL_MODERATOR, PROFIL_EDITOR, PROFIL_WRITER
  $this->setAdminProfil(PROFIL_ADMIN, PROFIL_MANAGER);

  # Autorisation d'acces à la configuration du plugin
  $this-> setConfigProfil(PROFIL_ADMIN, PROFIL_MANAGER);

  $this->responslidesjs = new responslidesjs();
  $this->responslidesjs->getSlides();

  # Personnalisation du menu
  $this->setAdminMenu(
   $this->getParam('menu')!='' ? $this->getParam('menu') : $this->getInfo('title')
   , $this->getParam('posm')!='0' ? $this->getParam('posm') : null
   , $this->getInfo('description')
  );

  # déclaration des hooks
  $this->addHook('AdminMediasTop', 'AdminMediasTop');
  $this->addHook('AdminMediasPrepend', 'AdminMediasPrepend');
  if($this->responslidesjs->aSlides){
   $this->addHook('ThemeEndHead', 'ThemeEndHead');
   $this->addHook('ThemeEndBody', 'ThemeEndBody');
   $this->addHook('ResponsiveSlidesJs', 'ResponsiveSlidesJs');
  }
 }

 public function AdminMediasTop(){
  echo '<?php
  $arr = array("ResponsiveSlidesJs" => array("responslidesjs_add" => "'.$this->getLang('L_ADD').'"));
  $selectionList = array_merge($selectionList, $arr);
  ?>';
 }

 public function AdminMediasPrepend(){
  if(isset($_POST['selection']) AND ($_POST['selection'] == 'responslidesjs_add') AND isset($_POST['idFile'])){
   $this->responslidesjs->editSlides($_POST);
   header('Location: medias.php');
   exit;
  }
 }

 public function ResponsiveSlidesJs(){
  echo '
  <div class="rslides_container">
   <ul class="rslides" id="responsiveslides">';
  foreach($this->responslidesjs->aSlides as $slide){//si images actives
   if($slide['active']){
    $fill = '<img class="rslidesfill" src="'.plxUtils::strCheck($slide['url']).'" title="'.plxUtils::strCheck($slide['title']).'" alt="'.strip_tags($slide['description']).'" />';
    if($this->getParam('fill'))
     $fill = '<div class="rslidesfill" style="background-image:url(\''.plxUtils::getRacine().plxUtils::strCheck($slide['url']).'\');"></div>';

    if($slide['description']!='')$fill .= '
      <p class="caption">'.strip_tags($slide['description'], '<strong><b><em><br>').'</p>';

    if($slide['onclick']!='')$fill = '
     <a href="'.plxUtils::strCheck($slide['onclick']).'">
      '.$fill.'
     </a>';
    elseif($this->getParam('lynx')!='0')$fill = '
     <a href="'.plxUtils::strCheck($slide['url']).'">
      '.$fill.'
     </a>';

    echo '
    <li title="'.plxUtils::strCheck($slide['title']).'">'.$fill.'
    </li>';
   }
  }
  echo "
   </ul>
  </div>\n";
 }

 public function ThemeEndHead(){
  echo '<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'plxResponsiveSlidesJs/responsiveslides/responsiveslides-styles.css" media="screen" />'."\n";
  echo '<style type="text/css">'."\n".
   "\t".'.rslides_container, .rslides_container .rslidesfill{ width:'.$this->getParam('width').'; height:'.$this->getParam('height').'; max-width:'.$this->getParam('maxwidth').'; max-height:'.$this->getParam('maxheight').'; }'."\n".
   "</style>\n";
 }

 public function ThemeEndBody(){
  echo "\t".'<script type="text/javascript" src="'.PLX_PLUGINS.'plxResponsiveSlidesJs/responsiveslides/responsiveslides.min.js"></script>'."\n";
  $keys = array('speed','pager','timeout','prevText','nextText','auto','namespace','nav','random','pause','pauseControls');
  $array = array();
  $parms = $this->getParams();
  foreach($parms as $key => $value){
   if(in_array($key, $keys) AND ($value['value']!='' OR $value['value']==1)){
    if(in_array($key, array('nav','random','pause')))
     $array[] = $key.':'.($value['value']==1?'true':'false');
    elseif($value['type']=='numeric')
     $array[] = $key.':'.$value['value'];
    else
     $array[] = $key.":'".$value['value']."'";
   }
  }
  $string = $array ? implode(',',$array) : '';
?>

<script type="text/javascript">
if (typeof jQuery == 'undefined'){
 document.write('<script type="text\/javascript" src="<?php echo PLX_PLUGINS ?>plxResponsiveSlidesJs\/responsiveslides\/jquery.min.js"><\/script>');
}
$(document).ready(function(){
 $('#responsiveslides').responsiveSlides({<?php echo $string ?>});
});
</script>
<?php
 }
}
?>
