<?php
class champArt extends plxPlugin {
 const PLUGIN_NAME = 'champArt';
 public function __construct($default_lang) {
  parent::__construct($default_lang);
  
  $this->setConfigProfil(PROFIL_ADMIN);

  $this->addHook('AdminTopEndHead', 'AdminTopEndHead');

  //AdminArticleContent #applé dans AdminArticleMix 
  if ($this->getParam('pos_vie')=='bot'){#choix dans la config
   $this->addHook('AdminArticleContent', 'AdminArticleMix');
  }else if($this->getParam('pos_vie')=='side'){
   $this->addHook('AdminArticleSidebar', 'AdminArticleMix');
  }else if($this->getParam('pos_vie')=='foot'){
   $this->addHook('AdminArticleFoot', 'AdminArticleMix');
  }else{
   $this->addHook('AdminArticleTop', 'AdminArticleMix');
  }

  $this->addHook('plxAdminEditArticleXml', 'plxAdminEditArticleXml');
  $this->addHook('plxMotorParseArticle', 'plxMotorParseArticle');
  $this->addHook(self::PLUGIN_NAME, self::PLUGIN_NAME);
 }

 public function AdminTopEndHead() { // insère la feuille de style du plugin que dans la page d'édition de l'article
  echo "\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.self::PLUGIN_NAME.'/style.css" media="screen" />'."\n";
 }
 
 public function AdminArticleMix() {
 $nbchamp = floor(sizeof($this->aParams)/4);
 for($i=1; $i<=$nbchamp; $i++) {
  $cPerso=$this->aParams['champ'.$i]['value'];
  $string = "
    \$".self::PLUGIN_NAME."_".$cPerso."='';
    if(!empty(\$_POST)) {
      \$".self::PLUGIN_NAME."_".$cPerso." = trim(\$_POST['".self::PLUGIN_NAME."_".$cPerso."']);
     if(!empty(\$_POST['preview'])) {
      \$art['".self::PLUGIN_NAME."_".$cPerso."'] = trim(\$_POST['".self::PLUGIN_NAME."_".$cPerso."']);
     }
    } elseif(!empty(\$_GET['a']) && isset(\$result['".self::PLUGIN_NAME."_".$cPerso."'])) {
     \$".self::PLUGIN_NAME."_".$cPerso." = trim(\$result['".self::PLUGIN_NAME."_".$cPerso."']);
    }
   ";
  echo "<?php ".$string." ?>";
  }
  $this->AdminArticleContent();
 }

 public function AdminArticleContent() {
  $nbchamp = floor(sizeof($this->aParams)/4); // compte le nombre de ligne
  $champgroupe = array(0); // création du tableau des groupes
  for($i=1; $i<=$nbchamp; $i++) {
   $label = $this->aParams['groupe'.$i]['value'];
   if(!empty($label)) :
    array_push($champgroupe, $label); // injecte les groupes non vides dans un tableau
   endif;
  }

  $champgroupe = array_unique($champgroupe); // supprime les groupes en doublons
  $champgroupe = array_values($champgroupe); // remet les clefs dans un bon ordre

  $nbgroupe = sizeof($champgroupe); // compte le nombre de groupe unique

  echo '<div id="'.self::PLUGIN_NAME.'" class="grid">'.PHP_EOL;

  for($j=1; $j<$nbgroupe; $j++) { // on boucle sur chaque groupe
   echo '<div class="col sml-12">'.PHP_EOL;
   echo '<fieldset class="article">'.PHP_EOL;
   echo '<legend>'.$champgroupe[$j]."&nbsp;<a id=\"toggler_grp_".$j."\" style=\"outline:none; text-decoration: none;\" title=\"".$this->getlang('L_MASQUER')." / ".$this->getlang('L_AFFICHER')."\" href=\"javascript:void(0)\" onclick=\"toggleDiv('toggle_grp_".$j."', 'toggler_grp_".$j."', '+','–')\">–</a></legend>".PHP_EOL;
   echo '<div id="toggle_grp_'.$j.'">'.PHP_EOL;
   for($i=1; $i<=$nbchamp; $i++) { // on boucle sur chaque ligne
    $cPerso = $this->aParams['champ'.$i]['value'];
    if($this->aParams['groupe'.$i]['value']==$champgroupe[$j] && !empty($cPerso)){ // si la ligne appartient à ce groupe et que cette ligne n'est pas vide
     echo "<label for=\"id_".self::PLUGIN_NAME."_".$cPerso."\">".$this->aParams['label'.$i]['value']." :&nbsp;&nbsp;<a id=\"toggler_".$cPerso."\" href=\"javascript:void(0)\" onclick=\"toggleDiv('toggle_".$cPerso."', 'toggler_".$cPerso."', '".$this->getlang('L_AFFICHER')."','".$this->getlang('L_MASQUER')."')\">";
     echo '<?php if(empty($'.self::PLUGIN_NAME.'_'.$cPerso.')){echo "'.$this->getlang('L_AFFICHER').'";}else{echo "'.$this->getlang('L_MASQUER').'";}?></a></label>'.PHP_EOL; // test si le champ possède une valeur. Si oui > affichage du champ, sinon il reste caché

     // affichage du champ sous la forme défini
     echo '<div id="toggle_'.$cPerso.'" class="col sml-12" style="<?php if(empty($'.self::PLUGIN_NAME.'_'.$cPerso.')){echo " display: none;";}?>">'; // test si le champ possède une valeur. Si oui > affichage du champ, sinon il reste caché
     if($this->aParams['type'.$i]['value']=="ligne"){ // si le champ est de type input ( ligne )
      echo '<?php plxUtils::printInput("'.self::PLUGIN_NAME.'_'.$cPerso.'",plxUtils::strCheck($'.self::PLUGIN_NAME.'_'.$cPerso.'),"text","42-255",false,"full-width","'.$cPerso.'"); ?>';
     } else { // sinon c'est un textarea ( bloc )
      echo '<?php plxUtils::printArea("'.self::PLUGIN_NAME.'_'.$cPerso.'",plxUtils::strCheck($'.self::PLUGIN_NAME.'_'.$cPerso.'),"20","5"); ?>';
     }
     echo '</div>'.PHP_EOL;
    }
   }
   echo '</div>'.PHP_EOL;

   echo '</fieldset>'.PHP_EOL;
   echo '</div>'.PHP_EOL;
  }
  echo '</div>'.PHP_EOL;
 }

 public function plxAdminEditArticleXml() {
 $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    echo "<?php \$xml .= \"\t\".'<".self::PLUGIN_NAME."_".$cPerso."><![CDATA['.plxUtils::cdataCheck(trim(\$content['".self::PLUGIN_NAME."_".$cPerso."'])).']]></".self::PLUGIN_NAME."_".$cPerso.">'.\"\n\"; ?>";
   endif;
  }
 }

 public function plxMotorParseArticle() {
 $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    echo "<?php if(isset(\$iTags['".self::PLUGIN_NAME."_".$cPerso."'][0])){ \$art['".self::PLUGIN_NAME."_".$cPerso."'] = trim(\$values[ \$iTags['".self::PLUGIN_NAME."_".$cPerso."'][0] ]['value']);} ?>";
   endif;
  }
 }

 public function champArt($param) {
  $plxMotor_inst = plxMotor::getInstance(); // permet de récupérer les champs de l'article
  $champ = array();
  $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    array_push($champ, plxUtils::strCheck($cPerso)); // on liste les champs non-vides
   endif;
  }

  if(in_array($param, $champ) AND $plxMotor_inst->plxRecord_arts->f(self::PLUGIN_NAME.'_'.$param)) { // si le paramètre fait parti du tableau des valeurs à afficher
   echo $plxMotor_inst->plxRecord_arts->f(''.self::PLUGIN_NAME.'_'.$param); // on affiche la valeur
  } elseif(in_array(substr($param, 0, -2), $champ) AND substr($param, -2)=="_R" AND $plxMotor_inst->plxRecord_arts->f(self::PLUGIN_NAME.'_'.substr($param, 0, -2))) { // si le paramètre fait parti du tableau des valeurs à retourner
   $return = $plxMotor_inst->plxRecord_arts->f(self::PLUGIN_NAME.'_'.substr($param, 0, -2));
   return $return;
  } elseif(in_array(substr($param, 0, -2), $champ) AND substr($param, -2)=="_L" AND $plxMotor_inst->plxRecord_arts->f(self::PLUGIN_NAME.'_'.substr($param, 0, -2))) { // si le paramètre fait parti du tableau des valeurs à retourner
   $nbchamp = sizeof($this->aParams)/4;
   for($i=1; $i<=$nbchamp; $i++) {
    if ($this->aParams['champ'.$i]['value']==substr($param, 0, -2)){
     echo "<span>".$this->aParams['label'.$i]['value'].":</span> ";
     echo $plxMotor_inst->plxRecord_arts->f(self::PLUGIN_NAME.'_'.substr($param, 0, -2));
    }
   }
  }
  return false;
 }
}