<?php
class champArt extends plxPlugin {

 public function __construct($default_lang) {
  parent::__construct($default_lang);
  
  $this->setConfigProfil(PROFIL_ADMIN);

  $this->addHook('AdminTopEndHead', 'AdminTopEndHead');
  $this->addHook('AdminArticleTop', 'AdminArticleTop');
  $this->addHook('AdminArticleContent', 'AdminArticleContent');
  $this->addHook('plxAdminEditArticleXml', 'plxAdminEditArticleXml');
  $this->addHook('plxMotorParseArticle', 'plxMotorParseArticle');
  $this->addHook('champArt', 'champArt');
 }

 public function AdminTopEndHead() { // insère la feuille de style du plugin que dans la page d'édition de l'article
  echo "\t".'<link rel="stylesheet" type="text/css" href="'.PLX_PLUGINS.'champArt/style.css" media="screen" />'."\n";
 }
 
 public function AdminArticleTop() {
 $nbchamp = floor(sizeof($this->aParams)/4);
 for($i=1; $i<=$nbchamp; $i++) {
  $cPerso=$this->aParams['champ'.$i]['value'];
  $string = "
    \$champArt_".$cPerso."='';
    if(!empty(\$_POST)) {
      \$champArt_".$cPerso." = trim(\$_POST['champArt_".$cPerso."']);
     if(!empty(\$_POST['preview'])) {
      \$art['champArt_".$cPerso."'] = trim(\$_POST['champArt_".$cPerso."']);
     }
    } elseif(!empty(\$_GET['a']) && isset(\$result['champArt_".$cPerso."'])) {
     \$champArt_".$cPerso." = trim(\$result['champArt_".$cPerso."']);
    }
   ";
  echo "<?php ".$string." ?>";
  }
 }

 public function AdminArticleContent() {
  $nbchamp = floor(sizeof($this->aParams)/4); // compte le nombre de ligne
  $champgroupe = array(0); // création du tableau des groupes
  for($i=1; $i<=$nbchamp; $i++) {
   $label = $this->aParams['groupe'.$i]['value'];
   if(!empty($label)) :
    array_push($champgroupe, $label); // injecte les groupes non vides dans un tableau
   endif;
  }

  $champgroupe = array_unique($champgroupe); // supprime les groupes en doublons
  $champgroupe = array_values($champgroupe); // remet les clefs dans un bon ordre

  $nbgroupe = sizeof($champgroupe); // compte le nombre de groupe unique

  echo '<div id="champart" class="grid">'.PHP_EOL;

  for($j=1; $j<$nbgroupe; $j++) { // on boucle sur chaque groupe
   echo '<div class="col sml-12">'.PHP_EOL;
   echo '<fieldset class="article">'.PHP_EOL;
   echo '<legend>'.$champgroupe[$j]."&nbsp;<a id=\"toggler_grp_".$j."\" style=\"outline:none; text-decoration: none;\" title=\"".$this->getlang('L_MASQUER')." / ".$this->getlang('L_AFFICHER')."\" href=\"javascript:void(0)\" onclick=\"toggleDiv('toggle_grp_".$j."', 'toggler_grp_".$j."', '+','–')\">–</a></legend>".PHP_EOL;
echo '<div id="toggle_grp_'.$j.'">'.PHP_EOL;
   for($i=1; $i<=$nbchamp; $i++) { // on boucle sur chaque ligne
    $cPerso = $this->aParams['champ'.$i]['value'];
    if($this->aParams['groupe'.$i]['value']==$champgroupe[$j] && !empty($cPerso)){ // si la ligne appartient à ce groupe et que cette ligne n'est pas vide
     echo "<label for=\"id_champArt_".$cPerso."\">".$this->aParams['label'.$i]['value']." :&nbsp;&nbsp;<a id=\"toggler_".$cPerso."\" href=\"javascript:void(0)\" onclick=\"toggleDiv('toggle_".$cPerso."', 'toggler_".$cPerso."', '".$this->getlang('L_AFFICHER')."','".$this->getlang('L_MASQUER')."')\">";
     echo '<?php if(empty($champArt_'.$cPerso.')){echo "'.$this->getlang('L_AFFICHER').'";}else{echo "'.$this->getlang('L_MASQUER').'";}?></a></label>'.PHP_EOL; // test si le champ possède une valeur. Si oui > affichage du champ, sinon il reste caché

     // affichage du champ sous la forme défini
     echo '<div id="toggle_'.$cPerso.'" class="col sml-12" style="<?php if(empty($champArt_'.$cPerso.')){echo " display: none;";}?>">'; // test si le champ possède une valeur. Si oui > affichage du champ, sinon il reste caché
     if($this->aParams['type'.$i]['value']=="ligne"){ // si le champ est de type input ( ligne )
      echo '<?php plxUtils::printInput("champArt_'.$cPerso.'",plxUtils::strCheck($champArt_'.$cPerso.'),"text","42-255",false,"full-width","'.$cPerso.'"); ?>';
     } else { // sinon c'est un textarea ( bloc )
      echo '<?php plxUtils::printArea("champArt_'.$cPerso.'",plxUtils::strCheck($champArt_'.$cPerso.'),"20","5"); ?>';
     }
     echo '</div>'.PHP_EOL;
    }
   }
echo '</div>'.PHP_EOL;

   echo '</fieldset>'.PHP_EOL;
   echo '</div>'.PHP_EOL;
  }
  echo '</div>'.PHP_EOL;
 }

 public function plxAdminEditArticleXml() {
 $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    echo "<?php \$xml .= \"\t\".'<champArt_".$cPerso."><![CDATA['.plxUtils::cdataCheck(trim(\$content['champArt_".$cPerso."'])).']]></champArt_".$cPerso.">'.\"\n\"; ?>";
   endif;
  }
 }

 public function plxMotorParseArticle() {
 $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    echo "<?php if(isset(\$iTags['champArt_".$cPerso."'][0])){ \$art['champArt_".$cPerso."'] = trim(\$values[ \$iTags['champArt_".$cPerso."'][0] ]['value']);} ?>";
   endif;
  }
 }

 public function champArt($param) {
  $plxMotor_inst = plxMotor::getInstance(); // permet de récupérer les champs de l'article
  $champ = array();
  $nbchamp = floor(sizeof($this->aParams)/4);
  for($i=1; $i<=$nbchamp; $i++) {
   $cPerso = $this->aParams['champ'.$i]['value'];
   if(!empty($cPerso)) :
    array_push($champ, plxUtils::strCheck($cPerso)); // on liste les champs non-vides
   endif;
  }

  if(in_array($param, $champ) AND $plxMotor_inst->plxRecord_arts->f('champArt_'.$param)) { // si le paramètre fait parti du tableau des valeurs à afficher
   echo $plxMotor_inst->plxRecord_arts->f('champArt_'.$param); // on affiche la valeur
  } elseif(in_array(substr($param, 0, -2), $champ) AND substr($param, -2)=="_R" AND $plxMotor_inst->plxRecord_arts->f('champArt_'.substr($param, 0, -2))) { // si le paramètre fait parti du tableau des valeurs à retourner
   $return = $plxMotor_inst->plxRecord_arts->f('champArt_'.substr($param, 0, -2));
   return $return;
  } elseif(in_array(substr($param, 0, -2), $champ) AND substr($param, -2)=="_L" AND $plxMotor_inst->plxRecord_arts->f('champArt_'.substr($param, 0, -2))) { // si le paramètre fait parti du tableau des valeurs à retourner
   $nbchamp = sizeof($this->aParams)/4;
   for($i=1; $i<=$nbchamp; $i++) {
    if ($this->aParams['champ'.$i]['value']==substr($param, 0, -2)){
     echo "<span>".$this->aParams['label'.$i]['value'].":</span> ";
     echo $plxMotor_inst->plxRecord_arts->f('champArt_'.substr($param, 0, -2));
    }
   }
  }
  return false;
 }

}

?>
