/**
 *  Objet de gestion de l'intgration de WYMeditor pour diter les articles
 *  de PluXml.
 *
 *  XXX Pas tip top comme implmentation mais le plus rapide. A voir plus tard
 *      pour une gestion plus propre et moins gourmande des instances d'diteur.
 */
var WEP = {
    /**
     * identifiant du textarea content
     * @type String
     */
    ID_CONTENT : 'id_content',
    /**
     * identifiant du textarea chapo
     * @type String
     */
    ID_CHAPO : 'id_chapo',
    
    /**
     * Chemin relatif du dossier plugin
     * @type String
     */
    dir : null,
    /**
     *  Liste des plugins WYMeditor  utiliser
     *  Les fichiers des plugins doivent avoir t dclars.
     *  @type String[]
     *  @private
     */
    plugins : [],
    /**
     *  Instance courante de l'diteur lors de l'insertion d'une image ou d'un
     *  lien depuis le gestionnaire de media.
     *  @type Object
     *  @private
     */
    current : null,
    
    /**
     *  Mthode d'initialisation  appeler pour grer les zones de texte content et
     *  chapo par WymEditor
     *  @param {String} dir Chemin du dossier du plugin.
     *  @param {String[]} plugins Liste des plugins WYMeditor  activer
     *  @param {String} lang Langue de l'interface
     */
    init: function (dir, plugins, lang, skin) {
        WEP.dir = dir;
        WEP.lang = lang;
        WEP.plugins = plugins;
        WEP.process(lang,skin);
    },
    /**
     * Instanciation des diteurs
     */
    process: function (lng,skn) {
        var cfg = {
            lang: lng,
            //stylesheet: WEP.dir + 'skin.css',
containersItems: [
            {'name': 'P', 'title': 'Paragraph', 'css': 'wym_containers_p'},
            /*{'name': 'H1', 'title': 'Heading_1', 'css': 'wym_containers_h1'},*/
            {'name': 'H2', 'title': 'Heading_2', 'css': 'wym_containers_h2'},
            {'name': 'H3', 'title': 'Heading_3', 'css': 'wym_containers_h3'},
            {'name': 'H4', 'title': 'Heading_4', 'css': 'wym_containers_h4'},
            {'name': 'H5', 'title': 'Heading_5', 'css': 'wym_containers_h5'},
            {'name': 'H6', 'title': 'Heading_6', 'css': 'wym_containers_h6'},
            {'name': 'PRE', 'title': 'Preformatted', 'css': 'wym_containers_pre'},
            {'name': 'BLOCKQUOTE', 'title': 'Blockquote', 'css': 'wym_containers_blockquote'},
            {'name': 'TH', 'title': 'Table_Header', 'css': 'wym_containers_th'}
        ], /*       WONT WORK    
containersItemHtml: [
            {'name': 'STRONG', 'title': 'Strong', 'css': 'wym_containers_strong'}
        ],            */
            
            skin: skn,//legacy,admove
            postInit: WEP.postInit
        }, content, chapo;
        // N'utiliser wymeditor que sur les articles
        if (document.getElementById('form_article')) {
            content = jQuery('#'+WEP.ID_CONTENT).wymeditor(cfg);
            chapo = jQuery('#'+WEP.ID_CHAPO).wymeditor(cfg);
            if (content.length || chapo.length) {
                // Mise  jour du bouton de submit : ajout de classe wymupdate
                jQuery('input[type="submit"]').addClass('wymupdate');
            }
        }
    },
    
    /**
     *  Callback de post initialisation :
     *  - Lancement des plugins
     *  - Ajout du bouton de gestion des media
     *  @param {Object} wym instance de l'diteur WYMeditor
     */
    postInit: function(wym) {
		// masquer le menu style (type de contenu en franais???)
		// XXX Voir si API wymeditor fournit qq chose
        //jQuery(wym._box).find('.wym_classes.wym_section.wym_dropdown').hide(); //in css
		// remplacer le bouton image
        for (var i = 0, n = WEP.plugins.length; i < n; i++) {//console.log(WEP.plugins);
            if (wym[WEP.plugins[i]]) {
                wym[WEP.plugins[i]]();
            }
        }
        //jQuery(wym._box).find(wym._options.toolsSelector).hide(); //all tools
		// masquer le bouton image old
		// XXX Voir si API wymeditor fournit qq chose
        //jQuery(wym._box).find('.wym_tools_image').hide(); //old
		// remplacer le bouton image
        WEP.addMediasButton(wym);
//console.log(wym._wym.element[0].id/*.object._index[0]*/);
        //adjust the editor's height
        //~ var height = wym._element[0].id == 'id_content' ? '456' : '345'; //0.5
        var height = wym._wym.element[0].id == 'id_content' ? '456' : '345'; //1.1.1
        jQuery(wym._box).find(wym._options.iframeSelector)
            .css('height', height + 'px');
    },
    /**
     *  Ajout du bouton medias
     *  @param {Object} wym instance de l'diteur WYMeditor
     */
    addMediasButton: function (wym) {
     //construct the button's html
     var html = "<li class='wym_tools_mediabutton'><a name='MediaButton' href='#'" + 
       " title='Medias' style='background-image: url(" + WEP.dir + 
       "wymeditor/skins/compact/icons.png); background-position: 0 -121px;'>" + 
       "Medias</a></li>";
     // add the button to the tools box
     //~ jQuery(wym._box)
      //~ .find(wym._options.toolsSelector + wym._options.toolsListSelector)
      //~ .append(html);
     jQuery(wym._box)
      .find('.wym_tools_image')
      .html(html);

     // handle click event
     // FIXME Vraiment, mais vraiment pas bon ! pourquoi?
     jQuery(wym._box).find('li.wym_tools_mediabutton a').click(function () {
      WEP.current = wym;
      WEP.openPopup(WEP.dir + 'medias.php?id=' + wym._wym.element[0].id.substr(3), 'Medias', '720', '580');
      return(false);
     });
    },
    
    /**
     *  Ouvrir la popup avec le fichier de gestion des medias
     *  @param {String} url Url de la page
     *  @param {String} name Titre de la fentre
     *  @param {int} width Largeur de la fentre
     *  @param {int} height Hauteur de la fentre
     */
    openPopup : function (url, name, width, height) {
		var popup = window.open(unescape(url) , name, "directories=no, toolbar=no, " + 
                "menubar=no, location=no, resizable=yes, scrollbars=yes, width=" + 
                width + " , height=" + height);
		if (popup) {
			popup.focus();
		} else {
			alert('Ouverture de la fentre bloque!');
		}
		return;
	},
	
    /**
     *  Mthode d'insertion d'une ressource.
     *  TODO Enrichir cette mthode.
     *  @param {String} id Identifiant de la zone dite.
     *  @param {String} url Url de la ressource.
     *  @param {String} name Nom de la ressource (alt image).
     *  @param {String} type Type de la ressource (image).
     */  
    insert: function (id, url, name, type) {
        var html = '';
        if (type === 'image') {
            html = '<img src="' + url + '" alt="' + name + '" />';
        } else {
            html = '<a href="' + url.replace(".tb", "") + '">' +
                    (type === 'thumb' ? '<img src="' + url + '" alt="' + name + '" />' : name) +
                    '</a>';
        }
        WEP.current.insert(html);
    }
};
